/// <reference types="node" />
import { Server as HttpServer } from 'http';
import { Http2Server, Http2SecureServer } from 'http2';
import { Server as HttpsServer } from 'https';
import { GraphQLSchema, DocumentNode } from 'graphql';
import { ApolloServerPlugin } from 'apollo-server-plugin-base';
import type WebSocket from 'ws';
import { GraphQLServerOptions } from './graphqlOptions';
import { Config, SubscriptionServerOptions, FileUploadOptions } from './types';
import { PlaygroundRenderPageOptions } from './playground';
import { GraphQLRequest } from './requestPipeline';
export declare class ApolloServerBase {
    private logger;
    subscriptionsPath?: string;
    graphqlPath: string;
    requestOptions: Partial<GraphQLServerOptions<any>>;
    private context?;
    private apolloConfig;
    protected plugins: ApolloServerPlugin[];
    protected subscriptionServerOptions?: SubscriptionServerOptions;
    protected uploadsConfig?: FileUploadOptions;
    private disableUploadsIfSchemaDoesNotUseUploadScalar;
    private subscriptionServer?;
    protected playgroundOptions?: PlaygroundRenderPageOptions;
    private parseOptions;
    private config;
    private state;
    protected schema?: GraphQLSchema;
    private toDispose;
    private toDisposeLast;
    private experimental_approximateDocumentStoreMiB;
    constructor(config: Config);
    setGraphQLPath(path: string): void;
    start(): Promise<void>;
    protected _start(): Promise<void>;
    protected willStart(): Promise<void>;
    private ensureStarted;
    protected ensureStarting(): void;
    private logStartupError;
    private startGatewayAndLoadSchema;
    private constructSchema;
    private generateSchemaDerivedData;
    disableUploads(): boolean;
    stop(): Promise<void>;
    installSubscriptionHandlers(server: HttpServer | HttpsServer | Http2Server | Http2SecureServer | WebSocket.Server): void;
    protected supportsSubscriptions(): boolean;
    protected supportsUploads(): boolean;
    protected serverlessFramework(): boolean;
    private ensurePluginInstantiation;
    private initializeDocumentStore;
    protected graphQLServerOptions(integrationContextArgument?: Record<string, any>): Promise<GraphQLServerOptions>;
    executeOperation(request: Omit<GraphQLRequest, 'query'> & {
        query?: string | DocumentNode;
    }, integrationContextArgument?: Record<string, any>): Promise<import("apollo-server-types").GraphQLResponse>;
}
//# sourceMappingURL=ApolloServer.d.ts.map