import { GraphQLError, GraphQLFormattedError } from 'graphql';
export declare class ApolloError extends Error implements GraphQLError {
    extensions: Record<string, any>;
    readonly name: any;
    readonly locations: any;
    readonly path: any;
    readonly source: any;
    readonly positions: any;
    readonly nodes: any;
    originalError: any;
    [key: string]: any;
    constructor(message: string, code?: string, extensions?: Record<string, any>);
}
export declare function toApolloError(error: Error & {
    extensions?: Record<string, any>;
}, code?: string): Error & {
    extensions: Record<string, any>;
};
export interface ErrorOptions {
    code?: string;
    errorClass?: new (message: string) => ApolloError;
}
export declare function fromGraphQLError(error: GraphQLError, options?: ErrorOptions): ApolloError;
export declare class SyntaxError extends ApolloError {
    constructor(message: string);
}
export declare class ValidationError extends ApolloError {
    constructor(message: string);
}
export declare class AuthenticationError extends ApolloError {
    constructor(message: string);
}
export declare class ForbiddenError extends ApolloError {
    constructor(message: string);
}
export declare class PersistedQueryNotFoundError extends ApolloError {
    constructor();
}
export declare class PersistedQueryNotSupportedError extends ApolloError {
    constructor();
}
export declare class UserInputError extends ApolloError {
    constructor(message: string, properties?: Record<string, any>);
}
export declare function formatApolloErrors(errors: ReadonlyArray<Error>, options?: {
    formatter?: (error: GraphQLError) => GraphQLFormattedError;
    debug?: boolean;
}): Array<ApolloError>;
export declare function hasPersistedQueryError(errors: Array<Error>): boolean;
//# sourceMappingURL=index.d.ts.map