"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Base class for search resource groups
 */
class SearchResourceGroup {
    /**
     * Create new instance of the search resource group
     * @param requester http handler
     * @param type the type of resource (should match /{resource}/ in the REST url path)
     * @param resource resource handler class
     */
    constructor(requester, type) {
        this.requester = requester;
        this.type = type;
    }
    create(schema, optionsOrCallback, callback) {
        return this.request({
            method: 'post',
            path: '/',
            body: schema,
        }, optionsOrCallback, callback);
    }
    list(optionsOrCallback, callback) {
        const options = typeof optionsOrCallback === 'function' ? {} : optionsOrCallback;
        return this.request({
            method: 'get',
            path: '/',
            query: options ? { $select: options.$select ? options.$select.join(',') : undefined } : undefined,
        }, optionsOrCallback, callback);
    }
    request(req, optionsOrCallback, callback) {
        req.path = `/${this.type}${req.path}`;
        return this.requester.request(req, optionsOrCallback, callback);
    }
}
exports.SearchResourceGroup = SearchResourceGroup;
//# sourceMappingURL=search-resource-group.js.map