import { CellValue } from './cell/cell-value.type';
import { ConfigValue } from './config/config-value.type';
import { RenderConfig } from './config/render-config.type';
import { TableBuilder } from './table-builder.class';
export declare class TableSnapshot {
    /** copy of original cell config on (x, y) coordinates */
    readonly cellConfig: RenderConfig[][];
    /** copy of original cell values on (x, y) coordinates */
    readonly cellValue: CellValue[][];
    /** copy of original column config on (x) coordinate */
    readonly columnConfig: ConfigValue[];
    /** column header values (or undefined for no headers) */
    readonly columnHeaders?: CellValue[];
    /** number of columns (excluding header) */
    readonly columns: number;
    /** copy of original row config on (y) coordinate */
    readonly rowConfig: ConfigValue[];
    /** row header values (or undefined for no headers) */
    readonly rowHeaders?: CellValue[];
    /** row count (excluding header) */
    readonly rows: number;
    /** -1 when row headers are present, 0 otherwise */
    readonly startX: number;
    /** -1 when column headers are present, 0 otherwise */
    readonly startY: number;
    /** copy of original table config */
    readonly tableConfig: ConfigValue;
    constructor(table: TableBuilder | TableSnapshot);
}
