"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const apg_lib_1 = require("apg-lib");
function infixAssertionValue(state, chars, phraseIndex, phraseLength, yard) {
    switch (state) {
        case apg_lib_1.ids.SEM_PRE:
            break;
        case apg_lib_1.ids.SEM_POST:
            const value = JSON.parse(apg_lib_1.utils.charsToString(chars, phraseIndex, phraseLength));
            if (typeof value !== "string" &&
                typeof value !== "number" &&
                typeof value !== "boolean" &&
                value !== null) {
                throw new Error("INVARIANT: Value is not scalar.");
            }
            yard.tracks.infixAssertionValue.push(value);
            break;
    }
    return apg_lib_1.ids.SEM_OK;
}
exports.infixAssertionValue = infixAssertionValue;
//# sourceMappingURL=infixAssertionValue.js.map