"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const apg_lib_1 = require("apg-lib");
function infixLogicalExpressionOperator(state, chars, phraseIndex, phraseLength, yard) {
    switch (state) {
        case apg_lib_1.ids.SEM_PRE:
            break;
        case apg_lib_1.ids.SEM_POST:
            const op = apg_lib_1.utils
                .charsToString(chars, phraseIndex, phraseLength)
                .toLowerCase();
            if (op !== "and" && op !== "or") {
                throw new Error(`INVARIANT: No such infix logical expression operator \`${op}\`.`);
            }
            yard.tracks.infixLogicalExpressionOperator.push(op);
            break;
    }
    return apg_lib_1.ids.SEM_OK;
}
exports.infixLogicalExpressionOperator = infixLogicalExpressionOperator;
//# sourceMappingURL=infixLogicalExpressionOperator.js.map